//
//  Normal Checker.js
//
//  v.081202 first version

//  (c) 2006, 2008 Hiroto Tsubaki
//  http://www.tres-graficos.jp/
//  tg@tres-graficos.jp
//
// 
// for scripts/Splineobj Folder

var cache = new Array;

// for debugging
Vec2D.prototype.toString = function() {
	return this.u.toFixed(4) + ', ' + this.v.toFixed(4);
}
Vec3D.prototype.toString = function() {
	return this.x.toFixed(4) + ', ' + this.y.toFixed(4) + ', ' + this.z.toFixed(4);
}
Vec4D.prototype.toString = function() {
	return this.x.toFixed(4) + ', ' + this.y.toFixed(4) + ', ' + this.z.toFixed(4) + ', ' + this.w.toFixed(4);
}
//
if( !Vec3D.len) {
	// returns a Vec3D as a result
	Vec3D.prototype.len = function() {
		if( arguments.length == 0)
			return Math.sqrt( this.x*this.x + this.y*this.y + this.z*this.z );
		var p = arguments[0].sub(this);
		return Math.sqrt( p.x*p.x + p.y*p.y + p.z*p.z );
	}
}
if( !Vec3D.normalize) {
	// returns a Vec3D as a result
	Vec3D.prototype.normalize = function() {
		var l = this.norm();
		if( l != 0) 
			return this.multiply(1/l);
		return this;
	}
}

function buildUI(obj) {
	
	obj.setParameter("name","Normal Checker");
	
	obj.addParameterSelector("target", ['parent','first child'],true,true);
	obj.addParameterSelector("create type",["points","faces","both"],true,true);
	obj.addParameterFloat("length",0.1,-1000,1000,true,true);
	
	
	obj.addParameterSeparator("Update");
	
	obj.addParameterButton("Update","Update","objectUpdate");
}

function objectUpdate(obj) {
	obj.update();
}

function buildObject(obj) {
	var core = obj.modCore();
	var cTar = parseInt(obj.getParameter("target"));
	var cType = parseInt(obj.getParameter("create type"));
	
	var len = obj.getParameter("length");
	
	switch(cTar) {
		case 0:
			var base = obj.owner();
			break;
		case 1:
			if (obj.childCount() > 0) var base = obj.childAtIndex(0);
			break;
	}
	if (base) {
		
		if (base.family() == NGONFAMILY) {
			var baseCore = base.modCore(); // 
			var basePolyCount = baseCore.polygonCount();
			var i,j;
			
			for (i = 0;i < basePolyCount;i++) {
				var bSize = baseCore.polygonSize(i);
				var p0 = new Vec3D(0,0,0);
				
				for (j = 0;j < bSize;j++) {
					var p1 = baseCore.vertex(baseCore.vertexIndex(i,j));
					
					if (cType != 1) { // not only face
						var norm = baseCore.normal(i, j);
						norm = norm.multiply(len);
						
						core.move(p1);
						core.line(p1.add(norm));
					}
					p0 = p0.add(p1);
				}
				if (cType != 0) { // not only point
					p0 = p0.multiply(1/bSize);
					var norm = baseCore.normal(i);
					norm = norm.multiply(len);
					
					core.move(p0);
					core.line(p0.add(norm));
				}
			}
		}
	}
}
